<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidFieldMapperException;
use Pimcore\Model\DataObject\AbstractObject;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Objects;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\DataCollector\DataCollectorInterface;
use Pimcore\Model\Element\ValidationException;

/**
 * Class ObjectListFieldMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class ObjectListFieldMapper implements FieldMapperInterface
{
    use PropertyAccessorTrait;

    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Objects;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     * @throws InvalidFieldMapperException
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $inheritedValues = AbstractObject::getGetInheritedValues();
        AbstractObject::setGetInheritedValues(true);

        $method = $this->getGetMethod($object, $property);

        /** @var Concrete[] $objects */
        $objects = $object->$method() ?: [];

        $objectIdList = array_map(function (Concrete $object) {
            // We want variant-ids only
            return $object->getId();
        }, array_filter($objects, function (Concrete $object) {
            // Skip unpublished variants
            return $object->isPublished();
        }));

        // Even an empty list has to be added to make delete possible
        $collector->addItem($property->getName(), 1 === count($objectIdList) ? reset($objectIdList) : $objectIdList);

        AbstractObject::setGetInheritedValues($inheritedValues);
    }
}
