<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\Compiler\PriorityTaggedServiceTrait;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Class FieldCollectionMapperPass
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class FieldCollectionMapperPass implements CompilerPassInterface
{
    use PriorityTaggedServiceTrait;

    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.mapping_field.field_collection_mapper')) {
            return;
        }

        $definition = $container->findDefinition('lifestyle_pimcore_export.mapping_field.field_collection_mapper');

        $taggedServices = $this->findAndSortTaggedServices('lifestyle_pimcore_export.field_collection_mapper', $container);
        foreach ($taggedServices as $service) {
            $definition->addMethodCall('addFieldCollectionMapper', [ $service ]);
        }
    }
}
