<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\AbstractObject;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\ClassDefinition\Data\AdvancedManyToManyRelation;
use Lifestyle\DataCollector\DataCollectorInterface;
use Pimcore\Model\DataObject\Data\ElementMetadata;

/**
 * Class AdvancedManyToManyRelation
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class AdvancedManyToManyRelationFieldMapper implements FieldMapperInterface
{
    use PropertyAccessorTrait;

    /**
     * Is the handler capable of handling this input
     *
     * @param Data $property
     *
     * @return boolean
     */
    public function handles(Data $property)
    {
        return $property instanceof AdvancedManyToManyRelation;
    }

    /**
     * Execute actual handling of given input
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $inheritedValues = AbstractObject::getGetInheritedValues();
        AbstractObject::setGetInheritedValues(true);

        $method = $this->getGetMethod($object, $property);

        /** @var Concrete[] $objects */
        $objects = $object->$method() ?: [];

        $objectIds = array_filter(array_map(function($object) {
            try {
                return $object->getElementId();
            } catch (\Exception $exception) {
                return null;
            }
        }, $objects));
        $collector->addItem($property->getName() . 'Ids', $objectIds);

        AbstractObject::setGetInheritedValues($inheritedValues);
    }
}
