<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Geopoint;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class GeopointFieldMapper
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class GeopointFieldMapper implements FieldMapperInterface
{
    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Geopoint;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $propertyName = $property->getName();
        $value = $object->getValueForFieldName($propertyName);
        if (false === $value || null === $value) {
            $value = $object->getValueFromParent($propertyName);
        }
        if (false !== $value && null !== $value) {
            $collector->addItem(
                $propertyName,
                [
                    'Longitude' => $value->getLongitude(),
                    'Latitude' => $value->getLatitude(),
                ]
            );
        }
    }
}
