<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Asset;

use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Pimcore\Model\Asset;

/**
 * Class AssetMapper
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Asset
 */
class AssetMapper implements MapperInterface
{
    const UNPUBLISH_EVENT = 'unpublish';
    const PUBLISH_EVENT = 'publish';

    use AssetMapperTrait;

    /**
     * @param Asset $asset
     * @return bool
     */
    public function applicable(Asset $asset): bool
    {
        return true;
    }

    /**
     * @param Asset $asset
     * @return DataCollectorInterface
     */
    public function getUpdateDataCollector(Asset $asset): DataCollectorInterface
    {
        return $this->mapAsset($asset, self::PUBLISH_EVENT);
    }

    /**
     * @param Asset $asset
     * @return DataCollectorInterface
     */
    public function getDeleteDataCollector(Asset $asset): DataCollectorInterface
    {
        return $this->mapAsset($asset, self::UNPUBLISH_EVENT);
    }
}
