<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\Pimcore\ExportBundle\Exception\InvalidFieldMapperException;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;

/**
 * Trait PropertyAccessorTrait
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
trait PropertyAccessorTrait
{
    /**
     * @param Concrete $object
     * @param Data $property
     * @return string
     * @throws InvalidFieldMapperException
     */
    private function getGetMethod(Concrete $object, Data $property): string
    {
        $propertyName = $property->getName();

        $method = 'get' . ucfirst($propertyName);
        if (!method_exists($object, $method)) {
            throw new InvalidFieldMapperException(sprintf(
                'Cannot map boolean property %s for export! Get-method does not exist in class %s.',
                $propertyName,
                get_class($object)
            ));
        }

        return $method;
    }
}
