<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\AbstractObject;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Checkbox;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class CheckboxFieldMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class CheckboxFieldMapper implements FieldMapperInterface
{
    use PropertyAccessorTrait;

    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Checkbox;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $inheritedValues = AbstractObject::getGetInheritedValues();

        // The get-method does have inheritance logic inside!
        $method = $this->getGetMethod($object, $property);

        if (null !== $object->getParent()) {
            AbstractObject::setGetInheritedValues(true);

            // Parent object should always have a valid value
            $value = (bool)$object->$method();
        } else {
            $value = $object->$method();
        }

        if (null !== $value) {
            $collector->addItem($property->getName(), (bool)$value);
        }

        AbstractObject::setGetInheritedValues($inheritedValues);
    }
}
