<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class AssetMapperPass
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Compiler
 */
class AssetMapperPass implements CompilerPassInterface
{
    /**
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $this->addAssetMappers($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws InvalidAssetMapperException
     */
    private function addAssetMappers(ContainerBuilder $container)
    {
        if (!$container->has('lifestyle_pimcore_export.mapping_asset.handler')) {
            return;
        }

        $definition = $container->findDefinition(
            'lifestyle_pimcore_export.mapping_asset.handler'
        );

        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle_pimcore_export.asset_mapper'
        );

        foreach ($taggedServices as $id => $attributes) {
            $serviceDefinition = $container->findDefinition($id);
            $priority = isset($attributes[0]['priority']) ? $attributes[0]['priority'] : 0;
            $definition->addMethodCall(
                'addAssetMapper',
                [new Reference($id), $priority]
            );
        }
    }
}
