<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Asset;

use Lifestyle\DataCollector\DataCollector;
use Pimcore\Model\Asset;

/**
 * Trait AssetMapperTrait
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Asset
 */
trait AssetMapperTrait
{
    /**
     * @param Asset $asset
     * @param string $eventName
     * @return DataCollector
     */
    private function mapAsset(Asset $asset, string $eventName): DataCollector
    {
        $collector = new DataCollector();
        $collector->addItem('id', $asset->getId());
        $collector->addItem('className', 'Asset' . ucfirst($asset->getType()));
        $collector->addItem('event', strtolower('asset.' . $asset->getType() . '.' . $eventName));
        $collector->addItem('type', 'asset');

        $collector->addItem('filename', $asset->getFilename());
        $collector->addItem('path', $asset->getPath());
        $collector->addItem('mimetype', $asset->getMimetype());

        return $this->addMetadata($collector, $asset);
    }

    /**
     * @param DataCollector $datacCollector
     * @param Asset $asset
     * @return DataCollector
     */
    private function addMetadata(DataCollector $datacCollector, Asset $asset): DataCollector
    {
        if ($asset->getHasMetaData()) {
            foreach ($asset->getMetadata() as $metadata) {
                $datacCollector->addItem(
                    'metadata_' . $metadata['name'],
                    $metadata['data'],
                    isset($metadata['language']) ? $metadata['language'] : null
                );
            }
        }

        return $datacCollector;
    }
}
