<?php

/**
 * Class FieldCollectionFieldMapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Mapping\FieldCollection\FieldCollectionMapperInterface;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Fieldcollections;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\Fieldcollection;
use Pimcore\Model\DataObject\Fieldcollection\Data\AbstractData;
use Pimcore\Model\DataObject\Exception\InheritanceParentNotFoundException;

/**
 * Class FieldCollectionMapper
 *
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class FieldCollectionMapper implements FieldMapperInterface
{
    /**
     * @var FieldCollectionMapperInterface[]
     */
    private $fieldCollectionMapper = [];

    /**
     * @param FieldCollectionMapperInterface $fieldCollectionMapper
     */
    public function addFieldCollectionMapper(FieldCollectionMapperInterface $fieldCollectionMapper)
    {
        $this->fieldCollectionMapper[] = $fieldCollectionMapper;
    }

    /**
     * handle
     *
     * @param Data $property
     *
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Fieldcollections;
    }

    /**
     * handles
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $propertyName = $property->getName();
        $fieldCollection = $object->getValueForFieldName($propertyName);
        if (!$fieldCollection instanceof Fieldcollection) {
            try {
                $fieldCollection = $object->getValueFromParent($propertyName);
            } catch (InheritanceParentNotFoundException $e) {
                // New Pimcore 6 Exception, no data from parent available
            }
        }
        if ($fieldCollection instanceof Fieldcollection) {
            foreach ($fieldCollection->getItems() as $fieldCollectionItem) {
                $this->mapFieldCollectionItem($collector, $object, $fieldCollectionItem);
            }
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param AbstractData $fieldCollectionItem
     */
    private function mapFieldCollectionItem(
        DataCollectorInterface $collector,
        Concrete $object,
        AbstractData $fieldCollectionItem
    ) {
        foreach ($this->fieldCollectionMapper as $fieldCollectionMapper) {
            if ($fieldCollectionMapper->handle($collector, $object, $fieldCollectionItem)) {
                return;
            }
        }
    }
}
