<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\FieldCollection;

use Lifestyle\DataCollector\DataCollectorInterface;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\Fieldcollection\Data\AbstractData;
/**
 * Interface FieldCollectionMapperInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\FieldCollection
 */
interface FieldCollectionMapperInterface
{
    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param AbstractData $fieldCollectionItem
     * @return bool Should return true, if $fieldCollectionItem has been mapped
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, AbstractData $fieldCollectionItem): bool;
}
