<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Asset;

use Pimcore\Model\Asset;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface MapperInterface
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Asset
 */
interface MapperInterface
{
    /**
     * @param Asset $asset
     * @return bool
     */
    public function applicable(Asset $asset): bool;

    /**
     * @param Asset $asset
     * @return DataCollectorInterface
     */
    public function getUpdateDataCollector(Asset $asset): DataCollectorInterface;

    /**
     * @param Asset $asset
     * @return DataCollectorInterface
     */
    public function getDeleteDataCollector(Asset $asset): DataCollectorInterface;
}
