<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Pimcore\ExportBundle\Configuration\LocaleConfiguration;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Block;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\Data\BlockElement;
use Pimcore\Model\DataObject\Localizedfield;

/**
 * Class BlockMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class BlockMapper implements FieldMapperInterface
{
    /**
     * @var LocaleConfiguration
     */
    private $localeConfiguration;

    /**
     * @var LocalizedFieldMapper
     */
    private $localizedFieldMapper;

    /**
     * BlockMapper constructor.
     * @param LocalizedFieldMapper $localizedFieldMapper
     */
    public function __construct(LocaleConfiguration $localeConfiguration, LocalizedFieldMapper $localizedFieldMapper)
    {
        $this->localeConfiguration = $localeConfiguration;
        $this->localizedFieldMapper = $localizedFieldMapper;
    }

    /**
     * @param Data $property
     *
     * @return boolean
     */
    public function handles(Data $property)
    {
        return $property instanceof Block;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        /** @var array $block */
        $block = $object->getValueForFieldName($property->getName());

        $locale = $this->localeConfiguration->usePrimaryLanguages()
            ? \Locale::getPrimaryLanguage($language)
            : $language;
        $useLocale = false; // could cache this

        $elements = [];

        /** @var array $blockChild */
        foreach ($block as $blockChild) {
            $element = [];

            /**
             * @var string $fieldName
             * @var BlockElement $blockElement
             */
            foreach ($blockChild as $fieldName => $blockElement) {
                /**
                 * @var string $fieldName
                 * @var string $fieldType
                 * @var mixed $fieldValue
                 */

                $fieldName = $blockElement->getName();
                //$fieldType = $blockElement->getType();
                $fieldValue = $blockElement->getData();

                if (is_scalar($fieldValue)) {
                    $element[$fieldName] = $fieldValue;
                } else {
                    // Handle special case(s):

                    if ($fieldValue instanceof Localizedfield) {
                        /** @var Localizedfield $fieldValue */

                        /**
                         * @var string $localization
                         * @var array $localizedFields
                         */
                        foreach ($fieldValue->getItems() as $localization => $localizedFields) {
                            if ($localization === $locale) {
                                $useLocale = true;

                                foreach ($localizedFields as $fieldName => $fieldValue) {
                                    if (is_scalar($fieldValue)) {
                                        $element[$fieldName] = $fieldValue;
                                    }
                                }

                                continue;
                            }
                        }
                    }
                }
            }

            $elements[] = $element;
        }

        if (!$useLocale) {
            $locale = null;
        }

        /**
         * NOTICE: When an "Localizedfield" is found all block properties are exported as localized data!
         */
        $collector->addItem($property->getName(), $elements, $locale);
    }
}
