<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\Concrete;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface FieldMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
interface FieldMapperInterface
{

    /**
     * Is the handler capable of handling this input
     *
     * @param Data $property
     *
     * @return boolean
     */
    public function handles(Data $property);

    /**
     * Execute actual handling of given input
     *
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language);
}
