<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Field;

use Lifestyle\DataCollector\DataCollectorItem;
use Pimcore\Model\DataObject\ClassDefinition\Data;
use Pimcore\Model\DataObject\ClassDefinition\Data\Classificationstore;
use Pimcore\Model\DataObject\Classificationstore\KeyConfig;
use Pimcore\Model\DataObject\Concrete;
use Pimcore\Model\DataObject\Exception\InheritanceParentNotFoundException;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class ClassificationStoreMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapping\Field
 */
class ClassificationStoreMapper implements FieldMapperInterface
{
    /**
     * @param Data $property
     * @return bool
     */
    public function handles(Data $property)
    {
        return $property instanceof Classificationstore;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param Concrete $object
     * @param Data $property
     * @param string $language
     */
    public function handle(DataCollectorInterface $collector, Concrete $object, Data $property, $language)
    {
        $classificationStore = $object->getValueForFieldName($property->getName());

        if (empty($classificationStore->getItems()) && $object->o_type === "variant") {
            try {
                $classificationStore = $object->getValueFromParent($property->getName());
            } catch (InheritanceParentNotFoundException $e) {
                // New Pimcore 6 Exception, no data from parent available
            }
        }

        $attributes = [];
        foreach ($classificationStore->getItems() as $groupId => $group) {
            foreach ($group as $keyId => $value) {
                $value = $classificationStore->getLocalizedKeyValue($groupId, $keyId, $language);
                if (is_array($value)) {
                    $value = implode(' , ', $value);
                }

                $attributes[KeyConfig::getById($keyId)->getName()] = $value;
            }
        }

        if ($collector->hasItem($property->getName())) {
            $collector->replaceItem(new DataCollectorItem($property->getName(), $attributes, null));
        } else {
            $collector->addItem($property->getName(), $attributes, null);
        }

        // Create one swoox slot for each attribute.
        foreach ($attributes as $attributeName => $attributeValue) {
            if (is_string($attributeName)) {
                $collector->addItem($attributeName, $attributeValue, null);
            }
        }
        return true;
    }
}
