<?php

/**
 * Class DefaultMapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\ExportBundle\Mapping\Object;

use Lifestyle\Pimcore\ExportBundle\Mapping\Object\MappingProcessor;
use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Class DefaultMapper
 * @package Lifestyle\Pimcore\ExportBundle\Mapper
 */
class DefaultMapper implements MapperInterface
{
    const UNPUBLISH_EVENT = 'unpublish';
    const PUBLISH_EVENT = 'publish';

    /**
     * @var MappingProcessor
     */
    private $mappingProcessor;

    /**
     * DefaultMapper constructor.
     * @param MappingProcessor $mappingProcessor
     */
    public function __construct(MappingProcessor $mappingProcessor)
    {
        $this->mappingProcessor = $mappingProcessor;
    }

    /**
     * @param $object
     * @return bool
     */
    public function applicable($object): bool
    {
        // just map if an object is given
        return null !== $object;
    }

    /**
     * @param \Pimcore\Model\DataObject\Product $object
     * @return DataCollectorInterface
     */
    public function getUpdateDataCollector($object): DataCollectorInterface
    {
        return $this->mappingProcessor->mapEverythingFromObject($object, self::PUBLISH_EVENT);
    }

    /**
     * @param \Pimcore\Model\DataObject\Product $object
     * @return DataCollectorInterface
     */
    public function getDeleteDataCollector($object): DataCollectorInterface
    {
        return $this->mappingProcessor->mapBaseFromObject($object, self::UNPUBLISH_EVENT);
    }
}
