# Pimcore Layout Changer bundle
This pimcore bundle can be configured to force different object and variant custom views for an object class

_**The custom views will not be applied for admin users**_ 
 
## Requirements
 Pimcore >= 5
 
## Installation
The repositories are private.
If your project is not using Lifestyle composer server (https://composer.life-style.de),
you have to add the following repository to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "repositories": [
    ...
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/pim/objectdynamiccustomlayoutchanger.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/pimcore-layoutchanger
```

## Configuration
##### Require the bundle in AppKernel.php
```php
if (class_exists('\Lifestyle\Pimcore\LayoutChangerBundle\LifestylePimcoreLayoutChangerBundle')) {
    $collection->addBundle(new \Lifestyle\Pimcore\LayoutChangerBundle\LifestylePimcoreLayoutChangerBundle());
}
```

##### Add some configuration to your config.yml
- You can add multiple custom_views configurations
- The custom_view key must be the classname of the object it should be applied to
- For each custom_view the object and variant layout ids mus be defined (ids of your predefined custom layouts in pimcore)

##### Example:
```yaml
lifestyle_pimcore_layout_changer:
    custom_views:
        Product:
            object_layout_id: 2
            variant_layout_id: 1
```
