<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\LayoutChangerBundle\Configuration;

/**
 * Class CustomViewConfig
 *
 * @package Lifestyle\Pimcore\LayoutChangerBundle\Configuration
 */
class CustomViewConfig
{
    /**
     * @var string
     */
    protected $className;
    /**
     * @var int
     */
    protected $objectViewId;
    /**
     * @var int
     */
    protected $variantViewId;

    /**
     * CustomViewConfig constructor.
     *
     * @param string $className
     * @param int    $objectViewId
     * @param int    $variantViewId
     */
    public function __construct(string $className, int  $objectViewId, int $variantViewId)
    {
        $this->className = $className;
        $this->objectViewId = $objectViewId;
        $this->variantViewId = $variantViewId;
    }

    /**
     * @return string
     */
    public function getClassName(): string
    {
        return $this->className;
    }

    /**
     * @return int
     */
    public function getObjectViewId(): int
    {
        return $this->objectViewId;
    }

    /**
     * @return int
     */
    public function getVariantViewId(): int
    {
        return $this->variantViewId;
    }
}
