<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @author      r.stetter
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\LayoutChangerBundle\Configuration;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class CustomViewList
 *
 * @package Lifestyle\Pimcore\LayoutChangerBundle\Configuration
 */
class CustomViewList
{
    /**
     * @var ArrayCollection|CustomViewConfig[]
     */
    protected $customViews;

    /**
     * CustomViewList constructor.
     */
    public function __construct()
    {
        $this->customViews = new ArrayCollection();
    }

    /**
     * @param CustomViewConfig $customViewConfig
     */
    public function addCustomView(CustomViewConfig $customViewConfig)
    {
        $this->customViews->set($customViewConfig->getClassName(), $customViewConfig);
    }

    /**
     * @param string $className
     *
     * @return bool
     */
    public function hasCustomViewConfig(string $className): bool
    {
        return $this->customViews->containsKey($className);
    }

    /**
     * @param string $className
     *
     * @return CustomViewConfig|null
     */
    public function getCustomViewConfig(string $className): ?CustomViewConfig
    {
        return $this->customViews->get($className);
    }
}
