<?php
/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright   2019 Lifestyle Webconsulting GmbH
 * @link        http://www.life-style.de
 */

namespace Lifestyle\Pimcore\LayoutChangerBundle\DependencyInjection;

use Lifestyle\Pimcore\LayoutChangerBundle\Configuration\CustomViewConfig;
use Lifestyle\Pimcore\LayoutChangerBundle\Configuration\CustomViewList;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\Yaml\Yaml;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class LifestylePimcoreLayoutChangerExtension extends Extension implements PrependExtensionInterface
{
    /**
     * {@inheritdoc}
     */
    public function prepend(ContainerBuilder $container)
    {

        $config = Yaml::parse(file_get_contents(__DIR__ . '/../Resources/config/config.yml'));

        if (count($config) > 0) {
            foreach ($config as $key => $configuration) {
                if (is_array($configuration) && count($configuration) > 0) {
                    $container->prependExtensionConfig($key, $configuration);
                }
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        if ($container->hasDefinition(CustomViewList::class)) {
            $definition = $container->getDefinition(CustomViewList::class);

            foreach ($config['custom_views'] as $className => $customViewConfig) {
                $definition->addMethodCall(
                    'addCustomView',
                    [new Definition(CustomViewConfig::class, [$className, $customViewConfig['object_layout_id'], $customViewConfig['variant_layout_id']])]
                );
            }
        }
    }
}
