<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\LayoutChangerBundle;

use Pimcore\Extension\Bundle\AbstractPimcoreBundle;
use Pimcore\Extension\Bundle\PimcoreBundleInterface;
use Pimcore\Extension\Bundle\Traits\PackageVersionTrait;

/**
 * Class LifestylePimcoreLayoutChangerBundle
 *
 * @package Lifestyle\Pimcore\LayoutChangerBundle
 */
class LifestylePimcoreLayoutChangerBundle extends AbstractPimcoreBundle implements PimcoreBundleInterface
{
    use PackageVersionTrait;

    /**
     * Returns the composer package name used to resolve the version
     *
     * @return string
     */
    protected function getComposerPackageName()
    {
        return 'lifestyle/pimcore-layoutchanger';
    }

    /**
     * getDescription
     *
     * @return string
     */
    public function getDescription()
    {
        return 'Update Layout for classes by user';
    }
}
