# Life-Style - Pimcore Order Inventory Bundle

Updates stock and onHold for products in Pimcore.

The bundle receives messages sent by the [Lifestyle-Sylius-Order-Inventory-Bundle](http://TODO) using the [RabbitMQ](https://www.rabbitmq.com). It uses the Life-Style [Data-Collector-Structure](https://stash.life-style.de/projects/SB/repos/data-collector-model).

## Requirements

Pimcore 5.6

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylepimcoreorderinventorybundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylerabbitmqconsumerbundle.git"
    },
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/sb/data-collector-model.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/pimcore-order-inventory-bundle
```

Add the bundle to the kernel:

app/AppKernel.php
```php
<?php

use Pimcore\HttpKernel\BundleCollection\BundleCollection;
use Pimcore\Kernel;

class AppKernel extends Kernel
{
    public function registerBundlesToCollection(BundleCollection $collection)
    {
        ...
        $collection->addBundle(new \Lifestyle\Pimcore\OrderInventory\LifestylePimcoreOrderInventoryBundle);
        ...
    }
}
```

## Configuration

You have to configure the [RabbitMqBundle](https://github.com/php-amqplib/RabbitMqBundle) as described in the [LifestyleRabbitMqConsumerBundle](http://TODO). You can also configure the properties used for 'onHand' and 'onHold'. This two object properties should be an integer.

app/config/config.yml
```yaml
lifestyle_pimcore_order_inventory:
  product_on_hand_property: 'stock'
  product_on_hold_property: 'stockOnHold'
```
