<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Class Configuration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory\DependencyInjection
 */
class Configuration implements ConfigurationInterface
{
    /**
     * Generates the configuration tree builder.
     *
     * @return TreeBuilder The tree builder
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $treeBuilder
            ->root('lifestyle_pimcore_order_inventory')
                ->children()
                    ->scalarNode('product_on_hand_property')
                        ->cannotBeEmpty()
                        ->defaultValue('stock')
                        ->info('The product class property for number of items in stock. On-Hand - products that are in stock.')
                        ->example('stock')
                    ->end()
                    ->scalarNode('product_on_hold_property')
                        ->cannotBeEmpty()
                        ->defaultValue('stockOnHold')
                        ->info('The product class property for number of items on hold. On-Hold - products sold but not payed yet.')
                        ->example('stockOnHold')
                    ->end()
                ->end()
        ;

        return $treeBuilder;
    }
}
