<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\Handler;

use Lifestyle\Pimcore\OrderInventory\Configuration\ProductConfiguration;
use Lifestyle\Pimcore\OrderInventory\Model\ProductMapper;
use Pimcore\Model\DataObject;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class ReleaseHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory\Handler
 */
class ReleaseHandler extends AbstractHandler
{
    /**
     * @var ProductConfiguration
     */
    private $productConfiguration;

    /**
     * ReleaseHandler constructor.
     * @param ProductConfiguration $productConfiguration
     * @param ProductMapper $mapper
     * @param ValidatorInterface $validator
     */
    public function __construct(
        ProductConfiguration $productConfiguration,
        ProductMapper $mapper,
        ValidatorInterface $validator
    ) {
        $this->productConfiguration = $productConfiguration;
        parent::__construct($mapper, $validator);
    }

    /**
     * @return string
     */
    protected function getResponsibleEvent(): string
    {
        return 'product.inventory.release';
    }

    /**
     * @param DataObject\AbstractObject $product
     * @param int $changedQuantity
     * @return bool
     * @throws \Exception
     */
    protected function execute(DataObject\AbstractObject $product, int $changedQuantity): bool
    {
        $onHoldProperty = $this->productConfiguration->getStockOnHoldPropertyName();
        $product->set($onHoldProperty, $product->get($onHoldProperty) - $changedQuantity);

        $product->save(['versionNote' => 'Auto update by inventory-release-process.']);

        return true;
    }
}
