<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\Model;

use Symfony\Component\Validator\Constraints as Assert;
use Lifestyle\Pimcore\OrderInventory\Validator\Constraints as LsAssert;

/**
 * Class Product
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Product
{
    /**
     * @Assert\NotNull(message="Object-id should not be null.")
     * @Assert\GreaterThan(message="Invalid object-id.", value=0)
     * @LsAssert\Product()
     * @var int
     */
    private $id;

    /**
     * @Assert\NotNull(message="Changed-quantity should not be null.")
     * @var int
     */
    private $changedQuantity;

    /**
     * @Assert\GreaterThanOrEqual(message="On-hold value should be greater or equal than 0.", value=0)
     * @var int|null
     */
    private $onHold;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id): void
    {
        $this->id = $id;
    }

    /**
     * @return int
     */
    public function getChangedQuantity(): int
    {
        return $this->changedQuantity;
    }

    /**
     * @param int $changedQuantity
     */
    public function setChangedQuantity(int $changedQuantity): void
    {
        $this->changedQuantity = $changedQuantity;
    }

    /**
     * @return int|null
     */
    public function getOnHold(): ?int
    {
        return $this->onHold;
    }

    /**
     * @param int|null $onHold
     */
    public function setOnHold(?int $onHold): void
    {
        $this->onHold = $onHold;
    }
}
