<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\Configuration;

/**
 * Class ProductConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory\Configuration
 */
class ProductConfiguration
{
    /**
     * @var string
     */
    private $stockPropertyName;

    /**
     * @var string
     */
    private $stockOnHoldPropertyName;

    /**
     * ProductConfiguration constructor.
     * @param string $stockPropertyName
     * @param string $stockOnHoldPropertyName
     */
    public function __construct(string $stockPropertyName, string $stockOnHoldPropertyName)
    {
        $this->stockPropertyName = $stockPropertyName;
        $this->stockOnHoldPropertyName = $stockOnHoldPropertyName;
    }

    /**
     * @return string
     */
    public function getStockPropertyName(): string
    {
        return $this->stockPropertyName;
    }

    /**
     * @return string
     */
    public function getStockOnHoldPropertyName(): string
    {
        return $this->stockOnHoldPropertyName;
    }
}
