<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\DependencyInjection;

use Lifestyle\Pimcore\OrderInventory\Configuration\NotifierConfiguration;
use Lifestyle\Pimcore\OrderInventory\Configuration\ProductConfiguration;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;

/**
 * Class LifestylePimcoreOrderInventoryExtension
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory\DependencyInjection
 */
class LifestylePimcoreOrderInventoryExtension extends Extension
{
    /**
     * Loads a specific configuration.
     *
     * @param array $configs
     * @param ContainerBuilder $container
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = $this->getConfiguration($configs, $container);
        $config = $this->processConfiguration($configuration, $configs);

        (new XmlFileLoader($container, new FileLocator(dirname(__DIR__) . '/Resources/config')))->load('services.xml');

        $this->setNotifierConfiguration($config, $container);
        $this->setProductConfiguration($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function setNotifierConfiguration(array $config, ContainerBuilder $container)
    {
        if (!$container->has(NotifierConfiguration::class)) {
            return;
        }

        $definition = $container->findDefinition(NotifierConfiguration::class);
        $definition->setArguments([
            $config['product_on_hand_notifier_enabled'],
            $config['product_on_hand_notifier_min'],
            $config['product_on_hand_notifier_sender_email'],
            $config['product_on_hand_notifier_sender_name'],
            $config['product_on_hand_notifier_recipients'],
        ]);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function setProductConfiguration(array $config, ContainerBuilder $container)
    {
        if (!$container->has(ProductConfiguration::class)) {
            return;
        }

        $definition = $container->findDefinition(ProductConfiguration::class);
        $definition->setArguments([
            $config['product_on_hand_property'],
            $config['product_on_hold_property'],
        ]);
    }
}
