<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory;

use Pimcore\HttpKernel\Bundle\DependentBundleInterface;
use Pimcore\HttpKernel\BundleCollection\BundleCollection;
use Pimcore\Extension\Bundle\Traits\PackageVersionTrait;
use Symfony\Component\HttpKernel\Bundle\Bundle;

/**
 * Class Lifestyle\Pimcore\OrderInventory
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory
 */
class LifestylePimcoreOrderInventoryBundle extends Bundle implements DependentBundleInterface
{
    use PackageVersionTrait;

    /**
     * Register bundles to collection.
     *
     * @param BundleCollection $collection
     */
    public static function registerDependentBundles(BundleCollection $collection)
    {
        $collection->addBundle(new \JMS\SerializerBundle\JMSSerializerBundle);
        $collection->addBundle(new \OldSound\RabbitMqBundle\OldSoundRabbitMqBundle);
        $collection->addBundle(new \Lifestyle\RabbitMq\Consumer\LifestyleRabbitMqConsumerBundle);
    }

    /**
     * @return string
     */
    protected function getComposerPackageName(): string
    {
        return 'lifestyle/pimcore-order-inventory-bundle';
    }
}
