<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\Configuration;

/**
 * Class NotifierConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory\Configuration
 */
class NotifierConfiguration
{
    /**
     * @var bool
     */
    private $enabled;

    /**
     * @var int
     */
    private $minOnHold;

    /**
     * @var string
     */
    private $senderEmail;

    /**
     * @var string
     */
    private $senderName;

    /**
     * @var array
     */
    private $recipients;

    /**
     * NotifierConfiguration constructor.
     * @param bool $enabled
     * @param int $minOnHold
     * @param string $senderEmail
     * @param string $senderName
     * @param array $recipients
     */
    public function __construct(
        bool $enabled,
        int $minOnHold,
        string $senderEmail,
        string $senderName,
        array $recipients
    ) {
        $this->enabled = $enabled;
        $this->minOnHold = $minOnHold;
        $this->senderEmail = $senderEmail;
        $this->senderName = $senderName;
        $this->recipients = $recipients;
    }

    /**
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->enabled;
    }

    /**
     * @return int
     */
    public function getMinOnHold(): int
    {
        return $this->minOnHold;
    }

    /**
     * @return string
     */
    public function getSenderEmail(): string
    {
        return $this->senderEmail;
    }

    /**
     * @return string
     */
    public function getSenderName(): string
    {
        return $this->senderName;
    }

    /**
     * @return array
     */
    public function getRecipients(): array
    {
        return $this->recipients;
    }
}
