<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\OrderInventory\Model;

use Lifestyle\DataCollector\DataCollectorInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class ProductMapper
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Pimcore\OrderInventory\Model
 */
class ProductMapper
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * ProductMapper constructor.
     * @param Factory $factory
     */
    public function __construct(Factory $factory)
    {
        $this->factory = $factory;
    }

    /**
     * @param DataCollectorInterface $dataCollector
     * @return Product
     */
    public function mapProduct(DataCollectorInterface $dataCollector): Product
    {
        $productData = $this->factory->product();

        if ($dataCollector->hasItem('id')) {
            $productData->setId((int)$dataCollector->getItemValue('id'));
        }

        if ($dataCollector->hasItem('changedQuantity')) {
            $productData->setChangedQuantity((int)$dataCollector->getItemValue('changedQuantity'));
        }

        if ($dataCollector->hasItem('onHold')) {
            $productData->setOnHold((int)$dataCollector->getItemValue('onHold'));
        }

        return $productData;
    }
}
