<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\RabbitMQBundle\DependencyInjection;

use Lifestyle\Pimcore\RabbitMQBundle\DependencyInjection\LifestylePimcoreRabbitMQExtension;
use Matthias\SymfonyDependencyInjectionTest\PhpUnit\AbstractExtensionTestCase;

/**
 * Class LifestyleSwooxRestApiClientExtensionTest
 * @package Tests\Lifestyle\Pimcore\RabbitMQBundle\DependencyInjection
 */
class LifestylePimcoreRabbitMQExtensionTest extends AbstractExtensionTestCase
{
    protected function getContainerExtensions()
    {
        return array(
            new LifestylePimcoreRabbitMQExtension()
        );
    }

    public function testCustomConfigurationWillBePrepended()
    {
        $this->load();

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.v_host'));
        $this->assertNull($this->container->getParameter('lifestyle_pimcore_rabbitmq.v_host'));

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.v_host'));
        $this->assertNull($this->container->getParameter('lifestyle_pimcore_rabbitmq.host'));

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.port'));
        $this->assertSame(0, $this->container->getParameter('lifestyle_pimcore_rabbitmq.port'));

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.username'));
        $this->assertNull($this->container->getParameter('lifestyle_pimcore_rabbitmq.username'));

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.password'));
        $this->assertNull($this->container->getParameter('lifestyle_pimcore_rabbitmq.password'));

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.exchange_name'));
        $this->assertNull($this->container->getParameter('lifestyle_pimcore_rabbitmq.exchange_name'));

        $this->assertTrue($this->container->hasParameter('lifestyle_pimcore_rabbitmq.request_format'));
        $this->assertSame('json', $this->container->getParameter('lifestyle_pimcore_rabbitmq.request_format'));
    }
}
