<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Pimcore\RabbitMQBundle\Event;

use Lifestyle\DataCollector\DataCollectorInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class PreUnpublishEvent
 * @package Lifestyle\Pimcore\RabbitMQBundle\Event
 */
class PreUnpublishEvent extends Event
{
    const NAME = 'rabbit_mq.pre_unpublish';

    /**
     * @var DataCollectorInterface
     */
    private $collector;

    /**
     * @param DataCollectorInterface $collector
     */
    public function __construct(DataCollectorInterface $collector)
    {
        $this->collector = $collector;
    }

    /**
     * @return DataCollectorInterface
     */
    public function getCollector(): DataCollectorInterface
    {
        return $this->collector;
    }
}
