<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\RabbitMQBundle\Producer;

use Lifestyle\Pimcore\RabbitMQBundle\Producer\ProducerAdapter;
use OldSound\RabbitMqBundle\RabbitMq\ProducerInterface as OldSoundProducerInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class ProducerAdapterTest
 * @package Tests\Lifestyle\Pimcore\RabbitMQBundle\Producer
 */
class ProducerAdapterTest extends TestCase
{
    public function testPublish()
    {
        $thirdPartyProducer = $this->getMockBuilder(OldSoundProducerInterface::class)->getMock();

        $thirdPartyProducer->expects($this->once())
            ->method('publish')
            ->with('it is adapted', 'unit.test.key', ['prop' => 'value'], ['header' => 'value']);

        $producerAdapter = new ProducerAdapter($thirdPartyProducer);
        $producerAdapter->publish(
            'it is adapted',
            'unit.test.key',
            ['prop' => 'value'],
            ['header' => 'value']
        );
    }
}
