# Pimcore5 Export to RabbitMQ
Install this pimcore5 plugin to export object updates to RabbitMQ.


## Installation

### Prerequisites

1. The base plugin to handle object updates in pimcore5 has to be installed - https://stash.life-style.de/projects/PIM/repos/pimcore5-export/browse.
2. Also make sure you have added the repository in your composer.json file:

```json
    {
        "repositories": [
            {
                  "type": "vcs",
                  "url": "ssh://git@stash.life-style.de:7999/pim/pimcore5-rabbitmq.git"
            }
        ]
    }
```

**3. Register additional bundle:**
```php
// app/AppKernel.php
 
public function registerBundles(): array
{
    if (class_exists('\\OldSound\\RabbitMqBundle\\OldSoundRabbitMqBundle')) {
        $collection->addBundle(new \OldSound\RabbitMqBundle\OldSoundRabbitMqBundle());
    }
 
    // ...
}
```

### Installation using composer
```
    composer require lifestyle/pimcore-rabbitmq dev-develop
```

If the plugin has been installed successfully, you can enable it in the pimcore extension manager.


### Configuration

Add the following parameters to your parameters.yml:

    lifestyle_pimcore_rabbitmq.v_host: "/" #Set default VHost to "/"
    lifestyle_pimcore_rabbitmq.host: ""
    lifestyle_pimcore_rabbitmq.port: ""
    lifestyle_pimcore_rabbitmq.username: "" 
    lifestyle_pimcore_rabbitmq.password: "" 
    lifestyle_pimcore_rabbitmq.exchange_name: "" #The name of the target exchange
    lifestyle_pimcore_swoox.request_format: "json" # The request content type (json|xml). Default is json.


### Docker RabbitMQ Image
```bash
    docker run -d --hostname my-rabbit --name mystim-queue -p 8080:15672 -p 8081:5672 rabbitmq:3-management
```


## Additional documentation

https://intranet.life-style.de/display/MYS/Pimcore+Export


Have fun!
