<?php

/**
 * Class Config
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\RabbitMQBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;

/**
 * Class Config
 * @package Lifestyle\Pimcore\RabbitMQBundle\Export
 */
class Config
{
    /**
     * @var string
     */
    private $vHost;

    /**
     * @var string
     */
    private $host;

    /**
     * @var int
     */
    private $port;

    /**
     * @var string
     */
    private $userName;

    /**
     * @var string
     */
    private $password;

    /**
     * @var string
     */
    private $exchangeName;

    /**
     * @var string
     */
    private $requestFormat;

    /**
     * @param string $vHost
     * @param string $host
     * @param int $port
     * @param string $userName
     * @param string $password
     * @param string $exchangeName
     * @param string $requestFormat
     */
    public function __construct($vHost, $host, $port, $userName, $password, $exchangeName, $requestFormat)
    {
        $this->vHost = $vHost;
        $this->host = $host;
        $this->port = $port;
        $this->userName = $userName;
        $this->password = $password;
        $this->exchangeName = $exchangeName;
        $this->requestFormat = $requestFormat;
    }


    /**
     * @throws PimcoreExportFailedException
     */
    public function validate()
    {
        if (
            strlen($this->vHost) <= 0 ||
            strlen($this->host) <= 0 ||
            (int) $this->port <= 0 ||
            strlen($this->userName) <= 0 ||
            strlen($this->password) <= 0 ||
            strlen($this->exchangeName) <= 0 ||
            !in_array($this->requestFormat, ['json', 'xml'])
        ) {
            throw new PimcoreExportFailedException(
                'Invalid or missing plugin configuration for RabbitMQ export handler!'
            );
        }
    }

    /**
     * @return string
     */
    public function getVHost()
    {
        return $this->vHost;
    }

    /**
     * @return string
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return int
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return string
     */
    public function getExchangeName()
    {
        return $this->exchangeName;
    }

    /**
     * @return string
     */
    public function getRequestFormat()
    {
        return $this->requestFormat;
    }
}
