<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Pimcore\RabbitMQBundle\Producer;

use OldSound\RabbitMqBundle\RabbitMq\ProducerInterface as OldSoundProducerInterface;
use PhpAmqpLib\Message\AMQPMessage;

/**
 * Class ProducerAdapter
 * @package Lifestyle\Pimcore\RabbitMQBundle\Producer
 */
class ProducerAdapter implements ProducerInterface
{
    const PROPERTY_MESSAGE_DELIVERY_MODE = 'delivery_mode';
    const MESSAGE_DELIVERY_MODE_PERSISTENCE = AMQPMessage::DELIVERY_MODE_PERSISTENT;

    /**
     * @var OldSoundProducerInterface
     */
    private $producer;

    /**
     * @param OldSoundProducerInterface $producer
     */
    public function __construct(OldSoundProducerInterface $producer)
    {
        $this->producer = $producer;
    }

    /**
     * @param string $message
     * @param string $routingKey
     * @param array $properties
     * @param array $headers
     */
    public function publish($message, $routingKey, $properties = [], $headers = [])
    {
        $this->producer->publish($message, $routingKey, $properties, $headers);
    }
}
