# Life-Style Pimcore SSO Plugin

This plugin connects Pimcore admin-login to the single sign on service.

## Requirements

- Pimcore 5.6 (tested)
- Pimcore 6.0 (should work, but untested)

## Installation

The repositories are private. You have to add them to your projects `composer.json`. Make sure you have access to the repositories.

```yaml
{
  "name": "your-project",

  ...

  "repositories": [
    {
      "type": "git",
      "url": "ssh://git@stash.life-style.de:7999/lcp/lifestylepimcoressoplugin.git"
    }
  ]
}
```

Install the package.

```bash
composer require lifestyle/pimcore-sso-plugin
```

## Configuration

The SSO plugin is already configured, only some parameters have to be set. SAML configuration has to be done.

### Configure Pimcore

#### Parameters

_app/config/local/parameters.yml_
```yaml
parameters:
  sso_application_name: 'MyPimcoreAdminApp'
  sso_service_provider_name: 'pimcore_admin'
```

#### Routing

Don't forget to configure the routing.

_app/config/routing.yml_: add the following lines
```yaml
_lifestyle_pimcore_sso:
    resource: "@LifestylePimcoreSsoBundle/Resources/config/routing.yaml"
```

#### Kernel

Add this to your kernel class:

```php
class AppKernel extends Kernel
{
    public function registerBundlesToCollection(BundleCollection $collection)
    {
        // ...
        if (class_exists('Lifestyle\Pimcore\Sso\LifestylePimcoreSsoBundle')) {
            $collection->addBundle(new \Lifestyle\Pimcore\Sso\LifestylePimcoreSsoBundle(), 61);
        }
        // ...
    }
    //...
}
```

### Configure SimpleSAMLphp

#### Service Provider (SP)

This plugin uses SimpleSAMLphp library in the background. The configuration is described at the [Service Provider quick start](https://simplesamlphp.org/docs/stable/simplesamlphp-sp). It seems to be a good idea to use the templates in `vendor/simplesamlphp/simplesamlphp/config-templates` and `vendor/simplesamlphp/simplesamlphp/metadata-templates`. The following describes only the parts that differ from the standard configuration. Please read the simpleSAMLphp documentation in detail before you continue.

Store your SAML configuration wherever you want. A good place may be the projects config folder:

```
config/
    saml/
        dev/
            certs/
                saml.crt
                saml.pem
            meta-data/
                saml20-idp-remote.php
            config.php
        prod/
            certs/
            meta-data/
```

Values, that have to be adjusted:

_config.php_
```
    // Should be the same as the alias in Apache configuration
    'baseurlpath' => 'sso/',
    
    // Paths should be absolute, otherwise you will not find your log files
    'certdir' => __DIR__ . '/certs/',
    'loggingdir' => dirname(dirname(dirname(__DIR__))) . '/var/log/',
    'datadir' => dirname(dirname(dirname(__DIR__))) . '/var/cache/dev/data/',
    'tempdir' => '/tmp/simplesaml',

    // See around line 105 of the config-template for further information 
    'secretsalt' => '2icb5vfpwbb7lm8ik3t0ldwpqqy7bxlf',

    // Admin section of simpleSAML should be protected
    'auth.adminpassword' => 'yourPersonalAdminSecret',
    'admin.protectindexpage' => true,
    'admin.protectmetadata' => true,

    // Find your metadata
    'metadatadir' => __DIR__ . '/metadata',
```

Values, that you might want to be adjusted:

_config.php_
```
    // Depends on your project
    'showerrors' => true,
    'errorreporting' => true,

    // Loglevel
    'logging.level' => SimpleSAML\Logger::NOTICE,
    'logging.handler' => 'syslog',
```

The authentication sources must be configured. We need different configurations for admin and shop. The name of each configuration should fit to Symfonys firewall configuration `service_provider_name`.

_authsources.php_
```php
<?php

$config = [

    'admin' => [
        'core:AdminPassword',
    ],

    'pimcore_admin' => [
        'saml:SP',
        'entityID' => null,
        'idp' => 'http://ls-sso-idp-v2.loc/saml2/idp/metadata.php',
        'discoURL' => null,
        'privatekey' => 'saml.pem',
        'certificate' => 'saml.crt',
    ],
];
```



#### Identity Provider (IdP)

The identity provider on the other side must know the service provider. The configuration is described in the [SimpleSAMLphp documentation](https://simplesamlphp.org/docs/stable/simplesamlphp-idp). For the next steps we assume that your IdP is up and running.

Add the IdPs metadata to your SP. The metadata may be found here:

- https://your-idp-domain.tld/saml2/idp/metadata.php?output=xhtml

The PHP file containing the configuration from above should be stored here `config/saml/dev/metadata/saml20-idp-remote.php`

Add your SPs metadata to the IdP. The metadata may be found here:

- https://your-domain.tld/sso/module.php/saml/sp/metadata.php/pimcore_admin?output=xhtml

The PHP file can be found in a location like `/path/to/your/idp/config/saml/ENV/metadata/saml20-sp-remote.php`. Before you add the two configurations to the IdPs metadata, they have to be adjusted like this. Add the 

```php
$metadata['https://your-domain.tld/sso/module.php/saml/sp/metadata.php/pimcore_admin'] = array (
    'attributes' => array_merge($_metaSpDefaultAttributes, ['application::MyPimcoreAdminApp']), // The application name has to be the same as in the firewall configuration
    'SingleLogoutService' =>
```

In most cases the `$_metaSpDefaultAttributes` variable is set at the top of the same file:

```php
$_metaSpDefaultAttributes = array(
    'guid',
    'lastname',
    'firstname',
    'username',
    'email',
    'authsource',
    'useridentifier',
);
``` 

### Configure Webserver

The `www`-folder of SimpleSAMLphp library needs to be accessible by the web server. Here is an example for Apache:

```
<VirtualHost *:80>

    ServerName my-domain.tld
    DocumentRoot "/absolute/path/to/pimcore/web"

    <Directory "/absolute/path/to/pimcore/web">
        Options Includes FollowSymLinks
        AllowOverride All
    </Directory>

    SetEnv SIMPLESAMLPHP_CONFIG_DIR /absolute/path/to/pimcore/config/saml/dev <== This must point to the folder that contains the config.php file

    Alias /sso/ /absolute/path/to/pimcore/vendor/simplesamlphp/simplesamlphp/www/

    <Directory "/absolute/path/to/pimcore/vendor/simplesamlphp/simplesamlphp/www">
        Options Includes FollowSymLinks
        AllowOverride All
        Order allow,deny
        Allow from all
    </Directory>

</VirtualHost>
```

### Configure the User Webservice (UWS)

Add the applications, you have configured in your firewall, to the UWS. To the admin-application add the roles `ROLE_ADMINISTRATION_ACCESS` and `ROLE_API_ACCESS`, to the shop-application add the role `ROLE_USER`. Connect the users, that should be able to login as admin or shop-user to the application for authentication and add the roles for authorization.

Now you should be able to login using single sign on. Good luck!
