# Pimcore SSO Plugin

## How it works

### Login

#### Trigger the login

There are two situations, where the login procedure has to be started:

* User clicks the login button to open the Pimcore admin login page
* User tries to open a protected admin page

To catch the request, if the user clicks the login button, we are using an event listener `Lifestyle\Pimcore\Sso\EventListener\LoginRequestListener`. The listener compares the current url to the Pimcore login url and redirects directly to the IdP.

If the user tries to reach a protected page, the `Lifestyle\Pimcore\Sso\Security\Authentication\SimpleSamlAuthenticator\SamlAuthenticationEntryPoint` starts the sso login.

In both cases the user is redirected to the IdP.

#### Start the login procedure

When the user is redirected back from the IdP, the user is already authenticated. The SAML response contains all necessary data to continue the process and authorize the user. At this point the `Lifestyle\Pimcore\Sso\Security\Firewall\SamlListener` comes into the game. The listener compares the request route to the configured `check_path`. That's the reason why the `SecurityController`s exist. The SAML response is parsed, stored into a token and the Symfony authentication starts calling the Provider `Lifestyle\Pimcore\Sso\Security\Authentication\Provider\SamlProvider`. If the route does not match the `check_path`, the listener tries to restore the token from session. This has to be done, because Pimcore wants the request to be stateless.

Normally the provider authenticates the user. As the user is already authenticated from the SSO, we use the provider to check some conditions and to create or update the user. The user providers uses the data from the SAML response to update or create the user. Roles, attributes and user data is synchronized from the SAML response into Pimcores database.

#### Finish the login

After the user has been updated or created, the user will be redirected to the default target page. Here we are using the Pimcore defaults. It also opens tabs if a deeplink has been set.

### Logout

The logout from the SSO starts after the Symfony logout has been finished. It uses the logout `success_handler` to redirect to the IdP to start the SSO logout. See `Lifestyle\Pimcore\Sso\Security\Logout\AdminUserLogoutHandler`.

### Behind the scenes

Most of the services depend on the firewall configuration. The `Lifestyle\Pimcore\Sso\Security\Factory\SamlFactory` builds all necessary services. For each firewall a set of services is created:

- Provider `SamlProvider`
- Entry Point `SamlAuthenticationEntryPoint`
- SAML authenticator `SimpleSamlAuthenticator`
- SAML listener `SamlListener`
- Login listener `LoginRequestListener`

The plugin comes with a ready-to-use configuration. Just set some parameters.
