<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Security\Authentication;

use SimpleSAML\Auth\Simple;
use Symfony\Component\Routing\RouterInterface;

/**
 * Class SimpleSamlAuthenticator
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Security\Authentication
 */
class SimpleSamlAuthenticator extends Simple
{
    /**
     * @var RouterInterface
     */
    private $router;

    /**
     * @var string|null
     */
    private $loginReturnPath;

    /**
     * @var string|null
     */
    private $logoutReturnPath;

    /**
     * SimpleSamlAuthenticator constructor.
     * @param RouterInterface $router
     * @param string|null $loginReturnPath
     * @param string|null $logoutReturnPath
     * @param string $authSource
     */
    public function __construct(RouterInterface $router, ?string $loginReturnPath, ?string $logoutReturnPath, string $authSource)
    {
        parent::__construct($authSource);
        $this->router = $router;
        $this->loginReturnPath = $loginReturnPath;
        $this->logoutReturnPath = $logoutReturnPath;
    }

    /**
     * @param null $returnTo
     * @return string
     */
    public function getLoginURL($returnTo = null)
    {
        if (null === $returnTo) {
            $returnTo = null === $this->loginReturnPath ? '/' : $this->router->generate($this->loginReturnPath);
        }

        return parent::getLoginURL($returnTo);
    }

    /**
     * @param null $returnTo
     * @return string
     */
    public function getLogoutURL($returnTo = null)
    {
        if (null === $returnTo) {
            $returnTo = null === $this->logoutReturnPath ? '/' : $this->router->generate($this->logoutReturnPath);
        }

        return parent::getLogoutURL($returnTo);
    }
}
