<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Security\Http\Authentication;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Http\Authentication\AuthenticationSuccessHandlerInterface;
use Symfony\Component\Security\Http\HttpUtils;

/**
 * Class AdminAuthenticationSuccessHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Security\Http\Authentication
 */
class AdminAuthenticationSuccessHandler implements AuthenticationSuccessHandlerInterface
{
    /**
     * @var RouterInterface
     */
    private $router;

    /**
     * @var HttpUtils
     */
    private $httpUtils;

    /**
     * AdminAuthenticationSuccessHandler constructor.
     * @param RouterInterface $router
     * @param HttpUtils $httpUtils
     */
    public function __construct(RouterInterface $router, HttpUtils $httpUtils)
    {
        $this->router = $router;
        $this->httpUtils = $httpUtils;
    }

    /**
     * @inheritDoc
     */
    public function onAuthenticationSuccess(Request $request, TokenInterface $token)
    {
        $deeplink = $request->get('deeplink');
        if ($deeplink && $deeplink !== 'true') {
            $url = $this->router->generate('pimcore_admin_login_deeplink') . '?' . $deeplink;
        } else {
            $url = $this->router->generate('pimcore_admin_index', [
                '_dc' => time()
            ]);
        }

        return $this->httpUtils->createRedirectResponse($request, $url);
    }
}
