<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Symfony\Component\Security\Http\Firewall;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\Event\RequestEvent;

// Be prepared for SF4 - this is for BC
if (class_exists(RequestEvent::class)) {
    if (!defined('IS_SYMFONY_4')) {
        define('IS_SYMFONY_4', true);
    }
} else {
    require_once __DIR__ . '/RequestEvent.php';
}

/**
 * Trait LegacyListenerTrait
 *
 * Prepare bundle for SF4 - remove as soon as using SF4.x
 *
 * @deprecated
 * @package Lifestyle\Pimcore\Sso\Security\Http\Firewall
 */
trait LegacyListenerTrait
{
    /**
     * @deprecated since Symfony 4.3, use __invoke() instead
     */
    public function handle(GetResponseEvent $event)
    {
        if (defined('IS_SYMFONY_4')) {
            @trigger_error(sprintf('The "%s()" method is deprecated since Symfony 4.3, use __invoke() instead.', __METHOD__), E_USER_DEPRECATED);
        }

        if (!$event instanceof RequestEvent) {
            $event = new class($event) extends RequestEvent {
                private $event;

                public function __construct(GetResponseEvent $event)
                {
                    parent::__construct($event->getKernel(), $event->getRequest(), $event->getRequestType());
                    $this->event = $event;
                }

                public function getResponse()
                {
                    return $this->event->getResponse();
                }

                public function setResponse(Response $response)
                {
                    $this->event->setResponse($response);
                }

                public function hasResponse()
                {
                    return $this->event->hasResponse();
                }
            };
        }

        $this->__invoke($event);
    }
}
