<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Model;

/**
 * Class SsoUser
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Model
 */
class SsoUser
{
    /**
     * @var string|null
     */
    private $username;

    /**
     * @var string|null
     */
    private $userId;

    /**
     * @var string|null
     */
    private $userGuid;

    /**
     * @var string|null
     */
    private $userIdentifier;

    /**
     * @var string|null
     */
    private $firstName;

    /**
     * @var string|null
     */
    private $lastName;

    /**
     * @var string|null
     */
    private $email;

    /**
     * SsoUser constructor.
     * @param string|null $username
     * @param string|null $userId
     * @param string|null $userGuid
     * @param string|null $userIdentifier
     * @param string|null $firstName
     * @param string|null $lastName
     * @param string|null $email
     */
    public function __construct(
        ?string $username,
        ?string $userId,
        ?string $userGuid,
        ?string $userIdentifier,
        ?string $firstName,
        ?string $lastName,
        ?string $email
    ) {
        $this->username = $username;
        $this->userId = $userId;
        $this->userGuid = $userGuid;
        $this->userIdentifier = $userIdentifier;
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->email = $email;
    }

    /**
     * @return string|null
     */
    public function getUsername(): ?string
    {
        return $this->username;
    }

    /**
     * @return string|null
     */
    public function getUserId(): ?string
    {
        return $this->userId;
    }

    /**
     * @return string|null
     */
    public function getUserGuid(): ?string
    {
        return $this->userGuid;
    }

    /**
     * @return string|null
     */
    public function getUserIdentifier(): ?string
    {
        return $this->userIdentifier;
    }

    /**
     * @return string|null
     */
    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    /**
     * @return string|null
     */
    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    /**
     * @return string|null
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }
}
