<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Security\Authentication\Provider;

use Lifestyle\Pimcore\Sso\Security\Authentication\Token\SamlToken;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Security\Core\User\UserProviderInterface;

/**
 * Interface SamlUserProviderInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Security\Authentication\Provider
 */
interface SamlUserProviderInterface extends UserProviderInterface
{
    /**
     * @param SamlToken $token
     * @return UserInterface
     */
    public function loadUserBySamlToken(SamlToken $token): UserInterface;
}
