<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Security\Http\Authentication;

use Lifestyle\Pimcore\Sso\Security\Authentication\Token\SamlToken;
use Pimcore\Model\User as UserModel;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Security\Http\Authentication\AuthenticationFailureHandlerInterface;
use Symfony\Component\Security\Http\HttpUtils;

/**
 * Class AdminAuthenticationFailureHandler
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Security\Http\Authentication
 */
class AdminAuthenticationFailureHandler implements AuthenticationFailureHandlerInterface, LoggerAwareInterface
{
    use LoggerAwareTrait;

    /**
     * @var HttpUtils
     */
    private $httpUtils;

    /**
     * AdminAuthenticationFailureHandler constructor.
     * @param HttpUtils $httpUtils
     */
    public function __construct(HttpUtils $httpUtils)
    {
        $this->httpUtils = $httpUtils;
    }

    /**
     * @inheritDoc
     */
    public function onAuthenticationFailure(Request $request, AuthenticationException $exception)
    {
        // User might not be connected to Pimcore - disable user
        $token = $exception->getToken();
        if ($token instanceof SamlToken) {
            $user = UserModel::getByName($token->getUsername());
            if ($user instanceof UserModel && $user->isActive()) {
                $user->setActive(false);
                $user->save();
            }
        }

        $this->logger->debug('Authentication failure, redirect triggered.', ['failure_path' => 'lifestyle_sso_admin_user_login_failure']);

        $request->getSession()->set(Security::AUTHENTICATION_ERROR, $exception);
        return $this->httpUtils->createRedirectResponse($request, 'lifestyle_sso_admin_user_login_failure');
    }
}
