<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\DependencyInjection\Compiler;

use Lifestyle\Pimcore\Sso\Security\Logout\AdminUserLogoutHandler;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class SimpleSamlAuthenticatorPass
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\DependencyInjection\Compiler
 */
class SimpleSamlAuthenticatorPass implements CompilerPassInterface
{
    /**
     * @inheritDoc
     */
    public function process(ContainerBuilder $container)
    {
        $taggedServices = $container->findTaggedServiceIds(
            'lifestyle.pimcore.sso.security.authentication.simple_saml_authenticator.admin'
        );
        $this->configureService(AdminUserLogoutHandler::class, $taggedServices, $container);
    }

    /**
     * @param string $serviceId
     * @param array $taggedServices
     * @param ContainerBuilder $container
     */
    private function configureService(string $serviceId, array $taggedServices, ContainerBuilder $container)
    {
        if (!$container->has($serviceId)) {
            return;
        }

        $definition = $container->findDefinition($serviceId);
        foreach ($taggedServices as $id => $tags) {
            $definition->setArgument(0, new Reference($id));
            break;
        }
    }
}
