<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Model;

/**
 * Class SsoResponse
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Model
 */
class SsoResponse
{
    /**
     * @var SsoApplication|null
     */
    private $application;

    /**
     * @var SsoUser|null
     */
    private $user;

    /**
     * SsoResponse constructor.
     * @param SsoApplication|null $application
     * @param SsoUser|null $user
     */
    public function __construct(?SsoApplication $application, ?SsoUser $user)
    {
        $this->application = $application;
        $this->user = $user;
    }

    /**
     * @return SsoApplication|null
     */
    public function getApplication(): ?SsoApplication
    {
        return $this->application;
    }

    /**
     * @return SsoUser|null
     */
    public function getUser(): ?SsoUser
    {
        return $this->user;
    }
}
