<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Lifestyle\Pimcore\Sso\Controller\Admin;

use Lifestyle\Pimcore\Sso\Exception\RuntimeException;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;
use Symfony\Component\Security\Core\Security;

/**
 * Class AdminSecurityController
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Lifestyle\Pimcore\Sso\Controller\Admin
 */
class SecurityController extends AbstractController
{
    /**
     * @Route("/admin/access-denied", name="lifestyle_sso_admin_user_login_failure")
     * @throws AccessDeniedException
     */
    public function loginFailure(Request $request)
    {
        $response = new Response('Access denied', 403);

        $parameters = [
            'exception' => $request->getSession()->get(Security::AUTHENTICATION_ERROR),
        ];

        return $this->render('@LifestylePimcoreSso/access_denied.html.twig', $parameters, $response);
    }

    /**
     * Overwrite pimcore default login-check-route
     *
     * @Route("/admin/sso-login-check", name="lifestyle_sso_admin_user_login_check", methods={"GET"})
     * @throws RuntimeException
     */
    public function loginCheck()
    {
        throw new RuntimeException('You must configure the check path to be handled by the firewall.');
    }
}
