<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollectorInterface;
use Swoox\Api\Model\Request\Delete\Swoox\Item as DeleteRequestItem;
use Swoox\Api\Model\Request\Delete\Swoox\Request as DeleteRequest;
use Swoox\Api\Model\Request\Index\Swoox\Item;
use Swoox\Api\Model\Request\Index\Swoox\NameFieldList;
use Swoox\Api\Model\Request\Index\Swoox\Request;

/**
 * Class Mapper
 * @package Lifestyle\Pimcore\SwooxBundle\Export
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return Request
     */
    public function mapUpdateRequestModel(DataCollectorInterface $collector)
    {
        $item = (new Item())
            ->setDocumentLanguage('de_DE')
            ->setDocumentPrefix('')
            ->setDocumentRanking('')
            ->setDocumentUniqueKey($collector->getItemValue('id'))
            ->setDocumentTitle('')
            ->setDocumentURL('')
            ->setDocumentText('');

        foreach ($collector->getItems() as $collectorItem) {
            $item->addDocumentFields(
                (new NameFieldList())
                    ->setName($collectorItem->getKey())
                    ->setValue($collectorItem->getValue())
                    ->setValueClean($collectorItem->getValue())
            );
        }

        $request = new Request();
        $request->addItem($item);

        return $request;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return DeleteRequest
     */
    public function mapDeleteRequestModel(DataCollectorInterface $collector)
    {
        return (new DeleteRequest())
            ->addItem(
                (new DeleteRequestItem())
                    ->setDocumentUniqueKey($collector->getItemValue('id'))
            );
    }
}
