<?php

/**
 * Class ConfigTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\Export;

use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\SwooxBundle\Export\Config;
use PHPUnit\Framework\TestCase;

/**
 * Class ConfigTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\Export
 */
class ConfigTest extends TestCase
{
    const EXPECTED_EXCEPTION_MESSAGE = 'Invalid or missing plugin configuration for swoox export handler!';

    public function testConfigIsInvalidNoClientId()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage(self::EXPECTED_EXCEPTION_MESSAGE);

        $config = new Config(null, 'unit_test_index_url', 'unit_test_delte_url', 'json');
        $config->validate();
    }

    public function testConfigIsInvalidNoIndexURL()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage(self::EXPECTED_EXCEPTION_MESSAGE);

        $config = new Config(123456, '', 'unit_test_delte_url', 'json');
        $config->validate();
    }

    public function testConfigIsInvalidNoDeleteURL()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage(self::EXPECTED_EXCEPTION_MESSAGE);

        $config = new Config(123456, 'unit_test_index_url', '', 'json');
        $config->validate();
    }

    public function testConfigIsInvalidInvalidRequestFormat()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage(self::EXPECTED_EXCEPTION_MESSAGE);

        $config = new Config(123456, 'unit_test_index_url', 'unit_test_delte_url', 'InvalidRequestFormat');
        $config->validate();
    }

    public function testConfigIsValid()
    {
        $config = new Config(123456, 'unit_test_index_url', 'unit_test_delte_url', 'json');

        try {
            $config->validate();
        } catch (\Exception $exception) {
            $this->fail('Config is valid but an exception was thrown!');
        }

        $this->assertTrue(true);
    }
}
