<?php

/**
 * Class HandlerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\Export;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Psr7\Response;
use JMS\Serializer\SerializerInterface;
use Lifestyle\Pimcore\ExportBundle\Exception\PimcoreExportFailedException;
use Lifestyle\Pimcore\ExportBundle\Mapping\DataCollector\DataCollector;
use Lifestyle\Pimcore\SwooxBundle\Export\Config;
use Lifestyle\Pimcore\SwooxBundle\Export\Handler;
use Lifestyle\Pimcore\SwooxBundle\Export\Mapper;
use Psr\Log\LoggerInterface;
use PHPUnit\Framework\TestCase;

/**
 * Class HandlerTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\Export
 */
class HandlerTest extends TestCase
{
    /**
     * @var Handler
     */
    private $handler;

    public function testIsResponsible()
    {
        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $client = $this->getMockBuilder(ClientInterface::class)->getMock();
        $config = $this->getMockBuilder(Config::class)->disableOriginalConstructor()->getMock();

        $handler = new Handler($client, $serializer, $logger, $mapper, $config);

        $dataCollector = new DataCollector();

        // Swoox handler should be responsible in all cases.
        $this->assertTrue($handler->isResponsible($dataCollector));

        $dataCollector->addItem('className', 'arbitraryClass');
        $this->assertTrue($handler->isResponsible($dataCollector));
    }

    public function testCreateOrUpdateSuccess()
    {
        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $config = new Config(123456, 'unit_test_index_url', 'unit_test_delte_url', 'json');

        $requestOptions = [
            'headers' => [
                'clientid' => $config->getClientId(),
            ],
            'body' => null,
        ];

        $client = $this->getMockBuilder(ClientInterface::class)
            ->getMock();
        $client->expects($this->once())
            ->method('request')
            ->with(Handler::HTTP_METHOD_PUT, $config->getIndexUrl(), $requestOptions)
            ->willReturn(new Response(200, []));

        $handler = new Handler($client, $serializer, $logger, $mapper, $config);

        $dataCollector = new DataCollector();
        $handler->createOrUpdate($dataCollector);
    }

    public function testDeleteSuccess()
    {
        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $config = new Config(123456, 'unit_test_index_url', 'unit_test_delte_url', 'json');

        $requestOptions = [
            'headers' => [
                'clientid' => $config->getClientId(),
            ],
            'body' => null,
        ];

        $client = $this->getMockBuilder(ClientInterface::class)
            ->getMock();
        $client->expects($this->once())
            ->method('request')
            ->with(Handler::HTTP_METHOD_DELETE, $config->getDeleteUrl(), $requestOptions)
            ->willReturn(new Response(200, []));

        $handler = new Handler($client, $serializer, $logger, $mapper, $config);

        $dataCollector = new DataCollector();
        $handler->delete($dataCollector);
    }

    public function testSendFailed()
    {
        $this->expectException(PimcoreExportFailedException::class);
        $this->expectExceptionMessage("Unit Test Error Message");

        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $config = new Config(123456, 'unit_test_index_url', 'unit_test_delte_url', 'json');

        // Create a mock and queue the responses.
        $mock = new MockHandler([
            new \Exception("Unit Test Error Message"),
        ]);

        $handler = HandlerStack::create($mock);
        $client = new Client(['handler' => $handler]);

        $handler = new Handler($client, $serializer, $logger, $mapper, $config);

        $dataCollector = new DataCollector();
        $handler->delete($dataCollector);
    }
}
